#include <stdio.h>
#include <stdlib.h>

int main(int argc, char **argv)
{
	FILE *ifp, *ofp_lo, *ofp_hi;
	unsigned char c;

	if ((ifp = fopen(argv[1], "rb")) == NULL) {
		fprintf(stderr,"\nCannot read: %s\n\n",argv[1]);
		return 1;
	}

	if ((ofp_lo = fopen("a1m68lo.a1", "w")) == NULL) {
		fprintf(stderr,"\nCannot write: %s\n\n","a1m68lo.a1");
		return 1;
	}

	if ((ofp_hi = fopen("a1m68hi.a2", "w")) == NULL) {
		fprintf(stderr,"\nCannot write: %s\n\n","a1m68hi.a2");
		return 1;
	}

	while(fread(&c, 1, 1, ifp) == 1) {
		printf("%02x\n",c);
		fprintf(ofp_lo,"%c",c & 0xF);
		fprintf(ofp_hi,"%c",c >> 4);
	}

	fclose(ifp);
	fclose(ofp_lo);
	fclose(ofp_hi);

	return 0;
}
